/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs;

import com.raoulvdberge.refinedstorage.api.autocrafting.engine.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.Input;
import it.unimi.dsi.fastutil.longs.LongList;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class DurabilityInput
extends Input {
    public static final String TYPE = "durability";
    private static final String NBT_MAX_DURABILITY = "MaxDurability";
    private static final String NBT_COMPAREABLE_ITEMSTACK = "CompareableItemstack";
    private final int maxDurability;
    private final ItemStack compareableItemStack;

    public DurabilityInput(@Nonnull ItemStack itemStack, long amountNeeded) {
        super((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{ItemStack.field_190927_a}), amountNeeded);
        this.getItemStacks().clear();
        this.getCurrentInputCounts().clear();
        this.compareableItemStack = itemStack;
        this.quantityPerCraft = 1;
        this.maxDurability = this.compareableItemStack.func_77958_k() + 1;
    }

    public DurabilityInput(@Nonnull NBTTagCompound compound) throws CraftingTaskReadException {
        super(compound);
        this.compareableItemStack = new ItemStack(compound.func_74775_l(NBT_COMPAREABLE_ITEMSTACK));
        this.maxDurability = compound.func_74762_e(NBT_MAX_DURABILITY);
    }

    public void addDamageableItemStack(@Nonnull ItemStack itemStack) {
        if (!itemStack.func_77984_f()) {
            throw new IllegalArgumentException("itemStack has to be damageable!");
        }
        this.getItemStacks().add(itemStack);
        this.getCurrentInputCounts().add((long)(itemStack.func_77958_k() - itemStack.func_77952_i()) + 1L);
        this.totalInputAmount = this.getCurrentInputCounts().stream().mapToLong(l -> l).sum();
    }

    @Override
    public void decreaseToCraftAmount(@Nonnull ItemStack stack) {
        if (!API.instance().getComparer().isEqual(this.compareableItemStack, stack, 2)) {
            return;
        }
        int needed = (int)Math.min(this.getToCraftAmount(), (long)stack.func_190916_E());
        for (int i = 0; i < needed; ++i) {
            this.addDamageableItemStack(stack.func_77946_l());
        }
        this.toCraftAmount = Math.max(0L, this.toCraftAmount - (long)needed);
        stack.func_190918_g(needed);
    }

    @Override
    public long increaseItemStackAmount(@Nonnull ItemStack stack, long amount) {
        throw new UnsupportedOperationException("#addDamageableItemStack should be used!");
    }

    @Override
    public void merge(Input input) {
        if (input.isFluid()) {
            throw new IllegalArgumentException("Other input cannot be a fluid");
        }
        this.getItemStacks().addAll(input.getItemStacks());
        this.getCurrentInputCounts().addAll((LongList)input.getCurrentInputCounts());
        this.totalInputAmount = this.getCurrentInputCounts().stream().mapToLong(l -> l).sum();
    }

    @Override
    @Nonnull
    public String getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNbt(@Nonnull NBTTagCompound compound) {
        super.writeToNbt(compound);
        compound.func_74768_a(NBT_MAX_DURABILITY, this.maxDurability);
        compound.func_74782_a(NBT_COMPAREABLE_ITEMSTACK, (NBTBase)this.compareableItemStack.func_77955_b(new NBTTagCompound()));
        return compound;
    }

    @Override
    public int getQuantityPerCraft() {
        return 1;
    }

    @Override
    public long getAmountMissing() {
        long missing = (long)Math.ceil((double)(this.getAmountNeeded() - this.totalInputAmount) / (double)this.maxDurability) - this.getToCraftAmount() * (long)this.maxDurability;
        return missing < 0L ? 0L : missing;
    }

    public long getTotalItemInputAmount() {
        return (long)Math.ceil((double)this.totalInputAmount / (double)this.maxDurability);
    }

    @Override
    public long getMinimumCraftableAmount() {
        return this.totalInputAmount;
    }

    @Override
    @Nonnull
    public ItemStack getCompareableItemStack() {
        return this.compareableItemStack;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurabilityInput input = (DurabilityInput)o;
        if (input.isFluid()) {
            return false;
        }
        return API.instance().getComparer().isEqual(this.getCompareableItemStack(), input.getCompareableItemStack(), 6);
    }

    public int hashCode() {
        int result = this.maxDurability;
        result = 31 * result + (this.compareableItemStack != null ? API.instance().getItemStackHashCode(this.compareableItemStack) : 0);
        return result;
    }
}

